
#IFDEF __STORY_DEBUG__
	Print __Alisha_._Project & " DevKit " & __Alisha_._Version_Pretty & " Core / Code / KVP22 / Text Box"
	WaitKey ( )

#ENDIF

Declare Function Text_Box_String ( Buffer As String = "", W As Long = 40, H As Long = 30 ) As String

Declare Function Text_Box_Render ( Buffer As String = "", W As Long = 40, H As Long = 30, Y_Scroll As Long = 0 ) As FB.Image Ptr

Declare Function KVP_Echo_Direct ( ByVal KVP_Text_Buffer As String = "" ) As String

Function Text_Box_String ( Buffer As String = "", W As Long = 40, H As Long = 30) As String

	If Len ( Buffer ) = 0 Then
		Return ""
	End If

	Dim As String Subject_Buffer = "", Queue_Buffer = "", Output_Buffer = ""
	
	Queue_Buffer = Buffer

	Do While StrPos ( SP & SP, Queue_Buffer ) > 0
		
		Queue_Buffer = Prefix ( SP & SP, Queue_Buffer ) & SP & Suffix ( SP & SP, Queue_Buffer )
		
	Loop

	Do While StrPos ( CRLF & CRLF, Queue_Buffer ) > 0
		
		Queue_Buffer = Prefix ( CRLF & CRLF, Queue_Buffer ) & CRLF & Suffix ( CRLF & CRLF, Queue_Buffer )
		
	Loop
	
	Do
		If Len ( Queue_Buffer ) = 0 Then
			Return Subject_Buffer
		End If
		
		Do While Len ( Prefix ( CRLF, Queue_Buffer ) ) < Len ( Prefix ( SP, Queue_Buffer ) )
			
			If Len ( Queue_Buffer ) = 0 Then
				Return Subject_Buffer
			End If

			Do While Len ( Prefix ( CRLF, Queue_Buffer ) ) > W
				If Len ( Queue_Buffer ) = 0 Then
					Return Subject_Buffer
				End If

				Output_Buffer &= Left( Queue_Buffer, W - Len ( Subject_Buffer ) - 1 ) & "-" & CRLF
			
				Queue_Buffer = Mid( Queue_Buffer, W - Len ( Subject_Buffer ) + 1 )
			
				Subject_Buffer = ""
				
			Loop
			
		Loop

		Do While Len ( Prefix ( SP, Queue_Buffer ) ) > W
			
			If Len ( Queue_Buffer ) = 0 Then
				Return Subject_Buffer
			End If
			
			Output_Buffer &= Left( Queue_Buffer, W - Len ( Subject_Buffer ) - 1 ) & "-" & CRLF
			
			Queue_Buffer = Mid( Queue_Buffer, W - Len ( Subject_Buffer ) + 1 )
			
			Subject_Buffer = ""
			
		Loop
		
		Select Case Len ( Subject_Buffer & Prefix ( SP, Queue_Buffer ) )
		
		Case IS <= W
		
			Subject_Buffer &= Prefix ( SP, Queue_Buffer )
			
		Case Else
		
			Output_Buffer &= Subject_Buffer & CRLF
			
			Subject_Buffer = ""
			
		End Select

		If Len ( Queue_Buffer ) = 0 Then
		
			Exit Do
			
		End If

	Loop
	
	Return Output_Buffer
	
End Function

Function Text_Box_Render ( Buffer As String = "", W As Long = 40, H As Long = 30, Y_Scroll As Long = 0 ) As FB.Image Ptr

	'Color RGBA ( 255, 255, 0, 255 )
	'Print "Function Text_Box_Render ( Buffer As String = " & QUOT & Buffer & QUOT & ", W As Long = "& QUOT & W & QUOT & ", H As Long = "& QUOT & H & QUOT & ", Y_Scroll As Long = "& QUOT & Y_Scroll & QUOT & " ) As FB.Image Ptr"

	Color RGBA ( 255, 255, 255, 255 )
	
	WaitKey ( )

	
	Dim As String Buff, Subject : Buff = Buffer : Subject = ""
	
	Dim As FB.Image Ptr Image = ImageCreate ( W * 8, H * 8, RGBA ( 0, 0, 0, 0 ), 32 )
	
	'Buff = Text_Box_String ( Buffer, W, H ) : Subject = ""
	
	Dim As Long X = 1, Y = 0

	Do While Len ( Buff ) > 0
		
		Y += 1
		
		Subject = Prefix( CRLF, Buff ) : Buff = Suffix( CRLF, Buff )
		
		If Y - Y_Scroll >= 1 AndAlso Y - Y_Scroll <= H Then
			
			Draw String Image, ( ( X - 1 ) * 8, ( Y - 1 - Y_Scroll ) * 8 ), Subject, RGBA ( 0, 255, 0, 255 )
		
		ElseIf Y - Y_Scroll > H Then
			
			Exit Do
		
		End If
		
		If Len ( Buff ) = 0 Then
		
			Exit Do
			
		End If
		
	Loop

	Line Image, ( 0, 0 ) - ( Image -> Width - 1, Image -> Height - 1 ), RGBA ( 255, 0, 0, 128 )
	
	Line Image, ( Image -> Width - 1, 0 ) - ( 0, Image -> Height - 1 ), RGBA ( 255, 0, 0, 128 )
	
	Return Image

End Function

Function KVP_Echo_Direct ( ByVal KVP_Text_Buffer As String = "" ) As String
	
	Dim As FB.Image Ptr KVP_Text_Image
	
	'KVP_Text_Buffer = Text_Box_String ( KVP_Text_Buffer, 40, 30 ) 
	KVP_Text_Image = Text_Box_Render ( KVP_Text_Buffer, 40, 30, 0 )
	
	Line KVP_Text_Image, ( 0, 0 ) - ( KVP_Text_Image -> Width - 1, KVP_Text_Image -> Height - 1 ), RGBA ( 0, 255, 0, 196 )
	
	Line KVP_Text_Image, ( KVP_Text_Image -> Width - 1, 0 ) - ( 0, KVP_Text_Image -> Height - 1 ), RGBA ( 0, 255, 0, 196 )
	
	Put ( 0, 0 ), KVP_Text_Image, Alpha : WaitKey ( )

	KVP_Text_Image = ImageDestroy2 ( KVP_Text_Image )
	
	Return KVP_Text_Buffer
	
End Function
